/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import journeymap.client.feature.FeatureManager;
import journeymap.common.Journeymap;
import journeymap.common.network.impl.Response;
import journeymap.server.Constants;
import journeymap.server.JourneymapServer;
import journeymap.server.config.ForgeConfig;
import journeymap.server.nbt.WorldNbtIDSaveHandler;
import journeymap.server.properties.DimensionProperties;
import journeymap.server.properties.GlobalProperties;
import journeymap.server.properties.PermissionProperties;
import journeymap.server.properties.Permissions;
import journeymap.server.properties.PropertiesManager;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.fml.loading.FMLLoader;

public class PlayerConfigController {
    private static PlayerConfigController INSTANCE;

    public static PlayerConfigController getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PlayerConfigController();
        }
        return INSTANCE;
    }

    public JsonObject getPlayerConfig(ServerPlayerEntity player) {
        JsonObject config = new JsonObject();
        JsonObject settings = new JsonObject();
        if (PropertiesManager.getInstance().getGlobalProperties().useWorldId.get().booleanValue() && (FMLLoader.getDist().isDedicatedServer() || Minecraft.func_71410_x().func_71401_C() != null && Minecraft.func_71410_x().func_71401_C().func_71344_c())) {
            WorldNbtIDSaveHandler worldSaveHandler = new WorldNbtIDSaveHandler();
            String worldID = worldSaveHandler.getWorldID();
            settings.addProperty("world_id", worldID);
        }
        settings.addProperty("can_teleport", Boolean.valueOf(this.canTeleport(player)));
        settings.addProperty("can_track", Boolean.valueOf(this.canPlayerTrack(player)));
        settings.addProperty("server_admin", Boolean.valueOf(this.canServerAdmin(player)));
        config.add("settings", (JsonElement)settings);
        config.addProperty("dim", this.getDimProperties(player));
        return config;
    }

    public boolean canServerAdmin(ServerPlayerEntity player) {
        List admins = (List)ForgeConfig.serverAdmins.get();
        for (String admin : admins) {
            if (!player.func_110124_au().toString().equals(admin) && !player.func_200200_C_().func_150254_d().equalsIgnoreCase(admin) && !Constants.debugOverride((Entity)player)) continue;
            return true;
        }
        if (JourneymapServer.isOp((PlayerEntity)player)) {
            return (Boolean)ForgeConfig.opAccess.get();
        }
        return false;
    }

    private String getDimProperties(ServerPlayerEntity player) {
        DimensionProperties dimensionProperties = PropertiesManager.getInstance().getDimProperties(player.field_71093_bK.func_186068_a());
        try {
            PermissionProperties prop = dimensionProperties.enabled.get() != false ? (DimensionProperties)dimensionProperties.clone() : (GlobalProperties)PropertiesManager.getInstance().getGlobalProperties().clone();
            if (JourneymapServer.isOp((PlayerEntity)player)) {
                prop.radarEnabled.set(prop.opRadarEnabled.get());
                prop.caveMappingEnabled.set(prop.opCaveMappingEnabled.get());
                prop.surfaceMappingEnabled.set(prop.opSurfaceMappingEnabled.get());
                prop.topoMappingEnabled.set(prop.opTopoMappingEnabled.get());
            }
            return prop.toJsonString(false);
        }
        catch (CloneNotSupportedException e) {
            Journeymap.getLogger().error("CloneNotSupportedException: ", (Throwable)e);
            return null;
        }
    }

    private boolean canTeleport(ServerPlayerEntity player) {
        if (PropertiesManager.getInstance().getDimProperties((int)player.field_71093_bK.func_186068_a()).enabled.get().booleanValue()) {
            return PropertiesManager.getInstance().getDimProperties((int)player.field_71093_bK.func_186068_a()).teleportEnabled.get();
        }
        if (PropertiesManager.getInstance().getGlobalProperties().teleportEnabled.get().booleanValue()) {
            return true;
        }
        return JourneymapServer.isOp((PlayerEntity)player);
    }

    private boolean canPlayerTrack(ServerPlayerEntity player) {
        if (PropertiesManager.getInstance().getGlobalProperties().playerTrackingEnabled.get().booleanValue()) {
            return true;
        }
        return PropertiesManager.getInstance().getGlobalProperties().opPlayerTrackingEnabled.get() != false && JourneymapServer.isOp((PlayerEntity)player);
    }

    public void updateClientConfigs(Response response) {
        if (response.getAsJson().get("settings") != null) {
            JsonObject settings = response.getAsJson().get("settings").getAsJsonObject();
            if (settings.get("world_id") != null) {
                Journeymap.getClient().setCurrentWorldId(settings.get("world_id").getAsString());
            }
            if (settings.get("can_teleport") != null) {
                Journeymap.getClient().setTeleportEnabled(settings.get("can_teleport").getAsBoolean());
            }
            if (settings.get("can_track") != null) {
                Journeymap.getClient().setPlayerTrackingEnabled(settings.get("can_track").getAsBoolean());
            }
            if (settings.get("server_admin") != null) {
                Journeymap.getClient().setServerAdmin(settings.get("server_admin").getAsBoolean());
            }
            String dimProperties = response.getAsJson().get("dim").getAsString();
            PermissionProperties prop = (PermissionProperties)new Permissions().load(dimProperties, false);
            FeatureManager.INSTANCE.updateDimensionFeatures(prop);
        }
    }
}

