/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.util.function.Supplier;
import journeymap.common.network.impl.CompressedPacket;
import journeymap.common.network.impl.Message;
import journeymap.common.network.impl.MessageProcessor;
import journeymap.common.network.impl.NetworkHandler;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.Logger;

public class MessageListener {
    private static Logger logger = NetworkHandler.getLogger();

    public static void handle(Message message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Gson gson = new GsonBuilder().serializeNulls().create();
            try {
                JsonObject response = (JsonObject)gson.fromJson(message.getMessage(), JsonObject.class);
                String clazz = response.get("container_object").getAsString();
                Class<?> requestObject = Class.forName(clazz);
                if (requestObject.getSuperclass() == MessageProcessor.class || requestObject.getSuperclass() == CompressedPacket.class) {
                    MessageProcessor.process(response, ctx.get(), requestObject);
                } else {
                    String error = String.format("Bad Network request: %s attempted to send an unqualified packet request.", ((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient() ? "THE SERVER" : ((NetworkEvent.Context)ctx.get()).getSender().func_200200_C_().func_150254_d());
                    logger.error(error);
                }
            }
            catch (ClassNotFoundException e) {
                logger.warn("Message processor not found: ", (Throwable)e);
            }
            catch (NullPointerException e) {
                logger.warn("Null Response: ", (Throwable)e);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

