/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.ingame;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Collection;
import journeymap.client.Constants;
import journeymap.client.cartography.color.RGB;
import journeymap.client.model.Waypoint;
import journeymap.client.properties.WaypointProperties;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.draw.MatrixDrawUtil;
import journeymap.client.render.ingame.WaypointRenderTypes;
import journeymap.client.waypoint.WaypointStore;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix3f;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;

public class WaypointRenderer {
    private WaypointProperties waypointProperties;
    private Minecraft minecraft = Minecraft.func_71410_x();
    private EntityRendererManager renderManager = this.minecraft.func_175598_ae();

    public void renderAllWaypoints(MatrixStack stack) {
        this.waypointProperties = Journeymap.getClient().getWaypointProperties();
        Collection<Waypoint> waypoints = WaypointStore.INSTANCE.getAll();
        int playerDim = this.minecraft.field_71439_g.field_71093_bK.func_186068_a();
        for (Waypoint waypoint : waypoints) {
            if (!waypoint.isEnable() || !waypoint.getDimensions().contains(playerDim)) continue;
            try {
                IRenderTypeBuffer.Impl buffers = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
                stack.func_227867_d_();
                stack.func_227860_a_();
                this.render(waypoint, stack, (IRenderTypeBuffer)buffers);
                stack.func_227865_b_();
                RenderSystem.disableDepthTest();
                buffers.func_228462_a_(WaypointRenderTypes.getIcon(waypoint.getTextureResource()));
            }
            catch (Throwable t) {
                Journeymap.getLogger().error("EntityWaypoint failed to render for " + waypoint + ": " + LogFormatter.toString(t));
            }
        }
    }

    private void render(Waypoint waypoint, MatrixStack stack, IRenderTypeBuffer buffers) {
        float partialTicks = this.minecraft.func_184121_ak();
        long gameTime = this.minecraft.field_71441_e.func_82737_E();
        float fadeAlpha = 1.0f;
        Vec3d waypointVec = waypoint.getPosition().func_72441_c(0.0, 0.118, 0.0);
        Vec3d playerVec = this.minecraft.field_71439_g.func_174791_d();
        double actualDistance = playerVec.func_72438_d(waypointVec);
        int maxDistance = this.waypointProperties.maxDistance.get();
        int minDistance = this.waypointProperties.minDistance.get();
        float[] rgba = RGB.floats(waypoint.getColor(), fadeAlpha * 0.4f);
        double viewX = this.renderManager.field_217783_c.func_216785_c().func_82615_a();
        double viewY = this.renderManager.field_217783_c.func_216785_c().func_82617_b();
        double viewZ = this.renderManager.field_217783_c.func_216785_c().func_82616_c();
        boolean showStaticInnerBeam = this.waypointProperties.showStaticBeam.get();
        boolean showRotatingOuterBeam = this.waypointProperties.showRotatingBeam.get();
        double viewDistance = actualDistance;
        double maxRenderDistance = this.minecraft.field_71474_y.field_151451_c * 16;
        NativeImage texture = waypoint.getNativeTexture();
        if (maxDistance > 0 && actualDistance > (double)maxDistance) {
            return;
        }
        if (waypoint.isDeathPoint() && this.waypointProperties.autoRemoveDeathpoints.get().booleanValue() && actualDistance < (double)this.waypointProperties.autoRemoveDeathpointDistance.get().intValue() && actualDistance > 1.5) {
            Journeymap.getLogger().debug("Auto removing deathpoint " + waypoint);
            WaypointStore.INSTANCE.remove(waypoint);
            return;
        }
        if (minDistance > 0) {
            if ((int)actualDistance <= minDistance) {
                return;
            }
            if ((int)actualDistance <= minDistance + 4) {
                fadeAlpha = (float)(actualDistance - (double)minDistance) / 3.0f;
            }
        }
        if (viewDistance > maxRenderDistance) {
            Vec3d delta = waypointVec.func_178788_d(playerVec).func_72432_b();
            waypointVec = playerVec.func_72441_c(delta.field_72450_a * maxRenderDistance, delta.field_72448_b * maxRenderDistance, delta.field_72449_c * maxRenderDistance);
            viewDistance = maxRenderDistance;
        }
        double scale = 0.00390625 * ((viewDistance + 4.0) / 3.0);
        double shiftX = waypointVec.field_72450_a - viewX;
        double shiftY = waypointVec.field_72448_b - viewY;
        double shiftZ = waypointVec.field_72449_c - viewZ;
        if (showStaticInnerBeam || showRotatingOuterBeam) {
            stack.func_227860_a_();
            stack.func_227861_a_(shiftX, -180.0, shiftZ);
            WaypointRenderer.renderBeamSegment(stack, buffers, partialTicks, gameTime, 1, 360, rgba, 0.2f, 0.25f, showStaticInnerBeam, showRotatingOuterBeam);
            stack.func_227865_b_();
        }
        if (this.lookingAtBeacon(waypointVec) && viewDistance > 0.5) {
            stack.func_227860_a_();
            this.renderNameTag(waypoint, texture, stack, buffers, fadeAlpha, scale, actualDistance, shiftX, shiftY, shiftZ);
            stack.func_227865_b_();
        }
        if (viewDistance > 0.1 && this.waypointProperties.showTexture.get().booleanValue()) {
            stack.func_227860_a_();
            this.renderIcon(waypoint, texture, stack, buffers, fadeAlpha, scale, shiftX, shiftY, shiftZ);
            stack.func_227865_b_();
        }
    }

    private void renderIcon(Waypoint waypoint, NativeImage texture, MatrixStack stack, IRenderTypeBuffer buffers, float alpha, double scale, double shiftX, double shiftY, double shiftZ) {
        int n = this.waypointProperties.textureSmall.get() != false ? 1 : 2;
        stack.func_227860_a_();
        stack.func_227861_a_(shiftX, shiftY, shiftZ);
        stack.func_227863_a_(this.renderManager.field_217783_c.func_227995_f_());
        stack.func_227862_a_((float)(-(scale *= (double)n)), (float)(-scale), (float)scale);
        IVertexBuilder vertexBuilder = buffers.getBuffer(WaypointRenderTypes.getIcon(waypoint.getTextureResource()));
        MatrixDrawUtil.drawColoredImage(texture, stack, vertexBuilder, waypoint.getColor(), alpha, (double)(0 - texture.func_195702_a() / 2) + 0.5, (double)(0 - (texture.func_195714_b() >> 1)) + 0.2, 0.0);
        stack.func_227865_b_();
    }

    private void renderNameTag(Waypoint waypoint, NativeImage texture, MatrixStack stack, IRenderTypeBuffer buffers, float alpha, double scale, double actualDistance, double shiftX, double shiftY, double shiftZ) {
        String distanceLabel = Constants.getString("jm.waypoint.distance_meters", "%1.0f");
        String label = waypoint.getName();
        boolean showName = this.waypointProperties.showName.get() != false && label != null && label.length() > 0;
        boolean showDistance = this.waypointProperties.showDistance.get();
        if (showName || showDistance) {
            StringBuilder sb = new StringBuilder();
            if (this.waypointProperties.boldLabel.get().booleanValue()) {
                sb.append(TextFormatting.BOLD);
            }
            if (showName) {
                sb.append(label);
            }
            if (showName && showDistance) {
                sb.append(" ");
            }
            if (showDistance) {
                sb.append(String.format(distanceLabel, actualDistance));
            }
            if (sb.length() > 0) {
                label = sb.toString();
                stack.func_227860_a_();
                stack.func_227861_a_(shiftX, shiftY, shiftZ);
                stack.func_227863_a_(this.renderManager.field_217783_c.func_227995_f_());
                stack.func_227862_a_((float)(-scale), (float)(-scale), (float)scale);
                int fontScale = this.waypointProperties.fontScale.get();
                double labelY = 0 - (texture.func_195714_b() >> 1) - 8;
                MatrixDrawUtil.drawLabel(label, stack, buffers, 1.0, labelY, DrawUtil.HAlign.Center, DrawUtil.VAlign.Above, -16777216, 0.6f * alpha, waypoint.getSafeColor(), alpha, fontScale, false);
                MatrixDrawUtil.drawLabel(label, stack, buffers, 1.0, labelY, DrawUtil.HAlign.Center, DrawUtil.VAlign.Above, -16777216, 0.4f * alpha, waypoint.getSafeColor(), alpha, fontScale, false);
                stack.func_227865_b_();
            }
        }
    }

    private boolean lookingAtBeacon(Vec3d waypointVec) {
        if (this.waypointProperties.autoHideLabel.get().booleanValue()) {
            double playerYaw;
            int angle = 5;
            double yaw = Math.atan2(this.renderManager.field_217783_c.func_216785_c().func_82616_c() - waypointVec.field_72449_c, this.renderManager.field_217783_c.func_216785_c().func_82615_a() - waypointVec.field_72450_a);
            double degrees = Math.toDegrees(yaw) + 90.0;
            if (degrees < 0.0) {
                degrees = 360.0 + degrees;
            }
            if ((playerYaw = (double)(this.minecraft.field_175622_Z.func_70079_am() % 360.0f)) < 0.0) {
                playerYaw += 360.0;
            }
            playerYaw = Math.toRadians(playerYaw);
            double playerDegrees = Math.toDegrees(playerYaw);
            return !(Math.abs((degrees += (double)angle) + (double)angle - ((playerDegrees += (double)angle) + (double)angle)) > (double)angle);
        }
        return true;
    }

    public static void renderBeamSegment(MatrixStack stack, IRenderTypeBuffer buffer, float partialTicks, long gameTime, int yOffset, int height, float[] colors, float beamRadius, float glowRadius, boolean showStaticInnerBeam, boolean showRotatingOuterBeam) {
        float texScale = 1.0f;
        int heightOffset = yOffset + height;
        float rotation = (float)Math.floorMod(gameTime, 40L) + partialTicks;
        float texOffset = -((float)(-gameTime) * 0.2f - (float)MathHelper.func_76141_d((float)((float)(-gameTime) * 0.1f))) * 0.6f;
        float red = colors[0];
        float blue = colors[1];
        float green = colors[2];
        float alpha = colors[3];
        IVertexBuilder beamBuffer = buffer.getBuffer(WaypointRenderTypes.getBeam());
        stack.func_227860_a_();
        if (!showStaticInnerBeam) {
            stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation * 2.25f - 45.0f));
        }
        float V2 = -1.0f + texOffset;
        float innerV1 = (float)height * texScale * (0.5f / beamRadius) + V2;
        WaypointRenderer.renderPart(stack, beamBuffer, red, blue, green, alpha, yOffset, heightOffset, 0.0f, beamRadius, beamRadius, 0.0f, -beamRadius, 0.0f, 0.0f, -beamRadius, 0.0f, 1.0f, innerV1, V2);
        stack.func_227865_b_();
        float outerV1 = (float)height * texScale + V2;
        stack.func_227860_a_();
        if (showRotatingOuterBeam) {
            stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation * 2.25f - 45.0f));
        }
        WaypointRenderer.renderPart(stack, beamBuffer, red, blue, green, alpha, yOffset, heightOffset, -glowRadius, -glowRadius, glowRadius, -glowRadius, -glowRadius, glowRadius, glowRadius, glowRadius, 0.0f, 1.0f, outerV1, V2);
        stack.func_227865_b_();
    }

    private static void renderPart(MatrixStack stack, IVertexBuilder buffer, float red, float green, float blue, float alpha, int yMin, int yMax, float p1, float p2, float p3, float p4, float p5, float p6, float p7, float p8, float u1, float u2, float v1, float v2) {
        MatrixStack.Entry entry = stack.func_227866_c_();
        Matrix4f matrixPos = entry.func_227870_a_();
        Matrix3f normal = entry.func_227872_b_();
        WaypointRenderer.addQuad(matrixPos, normal, buffer, red, green, blue, alpha, yMin, yMax, p1, p2, p3, p4, u1, u2, v1, v2);
        WaypointRenderer.addQuad(matrixPos, normal, buffer, red, green, blue, alpha, yMin, yMax, p7, p8, p5, p6, u1, u2, v1, v2);
        WaypointRenderer.addQuad(matrixPos, normal, buffer, red, green, blue, alpha, yMin, yMax, p3, p4, p7, p8, u1, u2, v1, v2);
        WaypointRenderer.addQuad(matrixPos, normal, buffer, red, green, blue, alpha, yMin, yMax, p5, p6, p1, p2, u1, u2, v1, v2);
    }

    private static void addQuad(Matrix4f matrixPos, Matrix3f normal, IVertexBuilder bufferIn, float red, float green, float blue, float alpha, int yMin, int yMax, float x1, float z1, float x2, float z2, float u1, float u2, float v1, float v2) {
        MatrixDrawUtil.addVertexUV(matrixPos, normal, bufferIn, red, green, blue, alpha, yMax, x1, z1, u2, v1);
        MatrixDrawUtil.addVertexUV(matrixPos, normal, bufferIn, red, green, blue, alpha, yMin, x1, z1, u2, v2);
        MatrixDrawUtil.addVertexUV(matrixPos, normal, bufferIn, red, green, blue, alpha, yMin, x2, z2, u1, v2);
        MatrixDrawUtil.addVertexUV(matrixPos, normal, bufferIn, red, green, blue, alpha, yMax, x2, z2, u1, v1);
    }
}

