/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.mod.vanilla;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import journeymap.client.cartography.color.ColoredSprite;
import journeymap.client.mod.IBlockSpritesProxy;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import org.apache.logging.log4j.Logger;

public class VanillaBlockSpriteProxy
implements IBlockSpritesProxy {
    private static Logger logger = Journeymap.getLogger();
    BlockModelShapes bms = Minecraft.func_71410_x().func_175602_ab().func_175023_a();

    @Override
    @Nullable
    public Collection<ColoredSprite> getSprites(BlockMD blockMD, @Nullable ChunkMD chunkMD, @Nullable BlockPos blockPos) {
        BlockState blockState = blockMD.getBlockState();
        Block block = blockState.func_177230_c();
        if (block instanceof FlowingFluidBlock) {
            ResourceLocation loc = ((FlowingFluidBlock)block).getFluid().getAttributes().getStillTexture();
            TextureAtlasSprite tas = Minecraft.func_71410_x().func_209506_al().func_229356_a_(AtlasTexture.field_110575_b).func_195424_a(loc);
            return Collections.singletonList(new ColoredSprite(tas, null));
        }
        if (blockState.func_206869_a().contains(DoublePlantBlock.field_176492_b)) {
            blockState = (BlockState)blockState.func_206870_a((IProperty)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.UPPER);
        }
        HashMap<String, ColoredSprite> map = new HashMap<String, ColoredSprite>();
        try {
            IBakedModel model = this.bms.func_178125_b(blockState);
            block2: for (BlockState state : new BlockState[]{blockState, null}) {
                for (Direction facing : new Direction[]{Direction.UP, null}) {
                    if (this.getSprites(blockMD, model, state, facing, map, chunkMD, blockPos)) break block2;
                }
            }
            if (map.isEmpty()) {
                TextureAtlasSprite defaultSprite = blockPos != null ? this.bms.getTexture(blockState, (World)Minecraft.func_71410_x().field_71441_e, blockPos) : this.bms.func_178122_a(blockState);
                if (defaultSprite != null) {
                    map.put(defaultSprite.func_195668_m().func_110623_a(), new ColoredSprite(defaultSprite, null));
                    if (!blockMD.isVanillaBlock() && logger.isDebugEnabled()) {
                        logger.debug(String.format("Resorted to using BlockModelStates.getTexture() to use %s as color for %s", defaultSprite.func_195668_m().func_110623_a(), blockState));
                    }
                } else {
                    logger.warn(String.format("Unable to get any texture to use as color for %s", blockState));
                }
            }
        }
        catch (Exception e) {
            logger.error("Unexpected error during getSprites(): " + blockMD.getBlock().getRegistryName().toString() + " - " + LogFormatter.toPartialString(e));
        }
        return map.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getSprites(BlockMD blockMD, IBakedModel model, @Nullable BlockState blockState, @Nullable Direction facing, HashMap<String, ColoredSprite> map, @Nullable ChunkMD chunkMD, @Nullable BlockPos blockPos) {
        RenderType originalLayer = MinecraftForgeClient.getRenderLayer();
        if (blockPos != null && chunkMD != null && chunkMD.getWorld() != null) {
            try {
                blockState = blockMD.getBlock().func_176223_P();
                model = this.bms.func_178125_b(blockState);
                blockState = blockMD.getBlock().getExtendedState(blockState, (IBlockReader)chunkMD.getWorld(), blockPos);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean success = false;
        try {
            for (RenderType layer : RenderType.func_228661_n_()) {
                List quads;
                if (!BlockRenderType.MODEL.equals((Object)blockMD.getBlockState().func_185901_i())) continue;
                ForgeHooksClient.setRenderLayer((RenderType)layer);
                EmptyModelData data = EmptyModelData.INSTANCE;
                if (blockPos != null) {
                    data = ModelDataManager.getModelData((World)Minecraft.func_71410_x().field_71441_e, (BlockPos)blockPos);
                }
                if (!this.addSprites(map, quads = model.getQuads(blockState, facing, new Random(), (IModelData)data))) continue;
                if (!blockMD.isVanillaBlock() && logger.isDebugEnabled()) {
                    logger.debug(String.format("Success during [%s] %s.getQuads(%s, %s, %s)", layer, model.getClass(), blockState, facing, 0));
                }
                success = true;
            }
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.error(String.format("Error during [%s] %s.getQuads(%s, %s, %s): %s", MinecraftForgeClient.getRenderLayer(), model.getClass(), blockState, facing, 0, LogFormatter.toPartialString(e)));
            }
        }
        finally {
            ForgeHooksClient.setRenderLayer((RenderType)originalLayer);
        }
        return success;
    }

    public boolean addSprites(HashMap<String, ColoredSprite> sprites, List<BakedQuad> quads) {
        if (quads == null || quads.isEmpty()) {
            return false;
        }
        if (quads.size() > 1) {
            HashSet<BakedQuad> culled = new HashSet<BakedQuad>(quads.size());
            culled.addAll(quads);
            quads = new ArrayList<BakedQuad>(culled);
        }
        boolean added = false;
        for (BakedQuad quad : quads) {
            ResourceLocation resourceLocation;
            String iconName;
            TextureAtlasSprite sprite = quad.func_187508_a();
            if (sprite == null || sprites.containsKey(iconName = quad.func_187508_a().func_195668_m().func_110623_a()) || (resourceLocation = new ResourceLocation(iconName)).equals((Object)new ResourceLocation("missingno"))) continue;
            sprites.put(iconName, new ColoredSprite(quad));
            added = true;
        }
        return added;
    }
}

