/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.io.nbt;

import journeymap.client.io.nbt.RegionLoader;
import journeymap.client.model.ChunkMD;
import journeymap.common.Journeymap;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.world.World;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimerWrapper;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraft.world.chunk.storage.ChunkLoader;
import net.minecraft.world.chunk.storage.ChunkSerializer;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;
import org.apache.logging.log4j.Logger;

public class JMChunkLoader {
    private static Logger logger = Journeymap.getLogger();

    public static ChunkMD getChunkMD(ChunkLoader loader, Minecraft mc, ChunkPos coord, boolean forceRetain) {
        if (RegionLoader.getRegionFile(mc, coord.field_77276_a, coord.field_77275_b).exists()) {
            IntegratedServer integratedServer = mc.func_71401_C();
            ServerWorld serverWorld = integratedServer.func_71218_a(mc.field_71439_g.field_71093_bK);
            Chunk chunk = JMChunkLoader.getChunkFromRegion(serverWorld, coord, loader);
            if (chunk != null) {
                chunk.func_177417_c(true);
                return new ChunkMD(chunk, forceRetain);
            }
        } else {
            logger.warn("Region doesn't exist for chunk: " + coord);
        }
        return null;
    }

    private static Chunk getChunkFromRegion(ServerWorld world, ChunkPos coord, ChunkLoader loader) {
        try {
            CompoundNBT nbt = loader.func_227078_e_(coord);
            if (nbt != null) {
                ChunkPrimerWrapper primer = (ChunkPrimerWrapper)ChunkSerializer.func_222656_a((ServerWorld)world, (TemplateManager)world.func_184163_y(), (PointOfInterestManager)world.func_217443_B(), (ChunkPos)coord, (CompoundNBT)nbt);
                Chunk chunk = primer.func_217336_u();
                return chunk;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static ChunkMD getChunkMdFromMemory(World world, int chunkX, int chunkZ) {
        AbstractChunkProvider provider;
        if (world != null && (provider = world.func_72863_F()) != null) {
            Chunk theChunk = world.func_212866_a_(chunkX, chunkZ);
            theChunk.func_177417_c(true);
            if (theChunk != null && theChunk.field_76636_d && !(theChunk instanceof EmptyChunk)) {
                return new ChunkMD(theChunk);
            }
        }
        return null;
    }
}

